<?php
include('inc/cpd-head.php');

$retrieve = new retrieve_CPD;
$session = $retrieve->retrieve_session($_REQUEST['sid']);
$event = $retrieve->retrieve_event($session->ParentId);
?>
<!DOCTYPE html>
<html>
  <head>
    <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1.0">
    <title>eliteCPD</title>
    <link href="//fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/materialize/1.0.0/css/materialize.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/dt/dt-1.12.1/fh-3.2.4/r-2.3.0/rg-1.2.0/datatables.min.css"/>
    <link rel="stylesheet" href="/style.css" type="text/css">
  </head>
  <body>
    <div class="container body-container">
    <div class="bg-header"><h2 class="truncate blue-grey-text text-darken-2">Dashboard</h2></div>
    <div class="dashboard-container row">
      <div class="row col s12">
        <div class="breadcrumbs">
          <ul>
            <li><a href="https://natcpd.optometry.org.au/">Dashboard</a></li>
            <li><?php echo $session->SessionName; ?></li>
          </ul>
        </div>
      </div>
      <?php if($session): ?>
        <div style="padding: 2em 1em;">
    <p style="margin: 0 0 1em;"><?php echo $event['EventName']; ?></p>
    <h2 style="margin-top: 0; font-size: 1.6em;"><?php echo $session->SessionId.' - '.$session->SessionName.' ('.$session->SessionDate.')'; ?></h2>
    <table id="sessionlog">
      <thead>
        <tr>
         <th>Attempt Id</th>
         <th>Member Id</th>
         <th>Full Name</th>
         <th>Delegate Web Id</th>
         <th>Action</th>
         <th>Completed Attempt?</th>
         <th>Pass/Fail</th>
         <th></th>
        </tr>
      </thead>
    <?php
$attempts = new Attempt;
$logs = $attempts->retrieve_logs($_REQUEST['sid']);

foreach($logs as $log){
  $log['jsondata'] = json_decode($log['AttemptInfo'], true);
  if(!isset($log['jsondata']['action']) && empty($log['jsondata']['action'])){
    $log['jsondata']['session-action'] = 'session-attend';
  } else {
    $log['jsondata']['session-action'] = $log['jsondata']['action'];
  }
  $retrieve_attendee = new retrieve_Attendee;
  $attendee = $retrieve_attendee->retrieve_Attendee_Details($log['UserId']);
 echo '<tr>';
  echo '<td>'.$log['AttemptId'].'</td>';
  echo '<td>'.$attendee['MemberId'].'</td>';
  echo '<td><strong>'.$attendee['FirstName'].' '.$attendee['LastName'].'</strong></td>';
  echo '<td>'.$attendee['PrefixDelegateId'].$attendee['DelegateWebId'].'</td>';
  echo '<td><span class="session-action '.$log['jsondata']['session-action'].'">'.$log['jsondata']['session-action'].'</span></td>';
  echo '<td><span class="completed '.$log['Completed'].'">'.$log['Completed'].'</span></td>';
  echo '<td><span class="passfail '.$log['PassFail'].'">'.$log['PassFail'].'</span></td>';
  echo '<td><span class="resend-email waves-effect waves-light btn tooltipped grey darken-3" data-action="'.$log['jsondata']['session-action'].'" data-attemptid="'.$log['Id'].'" data-position="right" data-tooltip="Resend email to Admin"><i class="material-icons">email</i></span></td>';
 echo '</tr>';
}
?>
</table>
<?php else: ?>
    <h2 style="font-size: 1.6em;">No Session Found</h2>
<?php endif; ?>
</div>

<?php include('footer.php'); ?>
