<?php
require_once('connect.php');

$request = json_decode(json_encode($_REQUEST), FALSE);
Class session_Record {
  Public function record_Question($sessionid, $questionarray){
      $core = Core::getInstance();
      if(!isset($questionarray->id) && empty($questionarray->id)){
      $questionsql = $core->dbc->prepare('INSERT INTO cpd_questions ( ParentId, Question, CorrectAnswer, QuestionNumber ) VALUES( :ParentId, :Question, :CorrectAnswer, :QuestionNumber )');
      $questionsql->execute(array(
        "ParentId"  => $sessionid,
        "Question"  => $questionarray->questionText,
        "CorrectAnswer" => $questionarray->iscorrect,
        "QuestionNumber" => $questionarray->order
      ));
      $questionid = $core->dbc->lastInsertId();
      $questionreturn['questionid'] = $questionid;
      $questionreturn['questionnumber'] = $questionarray->order;
      return $questionreturn;
    } else {
      $questionsql = $core->dbc->prepare('UPDATE cpd_questions SET ParentId=:ParentId, Question=:Question, CorrectAnswer=:CorrectAnswer, QuestionNumber=:QuestionNumber WHERE QuestionId=:QuestionId');
      $questionsql->execute(array(
        "ParentId"  => $sessionid,
        "Question"  => $questionarray->questionText,
        "CorrectAnswer" => $questionarray->iscorrect,
        "QuestionNumber" => $questionarray->order,
        "QuestionId" => $questionarray->id
      ));
      $questionreturn['questionid'] = $questionarray->id;
      $questionreturn['questionnumber'] = $questionarray->order;
      return $questionreturn;
    }
  }

  Public function record_Answer($questionid, $answerarray){
    $core = Core::getInstance();
    if(isset($answerarray->id) && !empty($answerarray->id)){
      $questionsql = $core->dbc->prepare('UPDATE cpd_answers SET ParentId=:ParentId, Answer=:Answer, AnswerNumber=:AnswerNumber WHERE AnswerId=:AnswerId');
      $questionsql->execute(array(
        "ParentId"  => $questionid,
        "Answer"  => $answerarray->answerText,
        "AnswerNumber" => $answerarray->order,
        "AnswerId" => $answerarray->id
      ));
      $answerreturn['questionid'] = $questionid;
      $answerreturn['answerid'] = $answerarray->id;
      $answerreturn['answerNumber'] = $answerarray->order;
      return($answerreturn);    
    } else {
      $questionsql = $core->dbc->prepare('INSERT INTO cpd_answers ( ParentId, Answer, AnswerNumber ) VALUES( :ParentId, :Answer, :AnswerNumber )');
      $questionsql->execute(array(
        "ParentId"  => $questionid,
        "Answer"  => $answerarray->answerText,
        "AnswerNumber" => $answerarray->order
      ));
      $answerreturn['questionid'] = $questionid;
      $answerreturn['answerid'] = $core->dbc->lastInsertId();
      $answerreturn['answerNumber'] = $answerarray->order;
      return($answerreturn);
    }
  }

  Public function record_SessionDetails($sessionid, $sessionarray){
    $core = Core::getInstance();
    if(!isset($sessionarray->slot) ||empty($sessionarray->slot)){
      $sessionarray->slot = 1;
    }
    $sessionsql = $core->dbc->prepare('UPDATE cpd_sessions SET Slot=:Slot, SessionDate=:SessionDate, Start_Time=:StartTime, End_Time=:EndTime WHERE SessionId=:SessionId');
    $sessionsql->execute(array(
      "Slot" => $sessionarray->slot,
      "SessionDate" => $sessionarray->date,
      "StartTime" => $sessionarray->startTime,
      "EndTime" => $sessionarray->endTime,
      "SessionId" => $sessionid
    ));
  }
}

Class User {
  Public function retrieve_Attempts($userid, $sessionid){
      $core = Core::getInstance();
      $attemptsql = $core->dbc->prepare('SELECT * FROM cpd_attempts WHERE UserId=:UserId AND ParentId=:ParentId ORDER BY AttemptId ASC');
      $attemptsql->execute(array(
        "UserId" => $userid,
        "ParentId" => $sessionid
      ));
      $attempts = $attemptsql->fetchAll(PDO::FETCH_ASSOC);
      $attemptcount = 0;
      foreach($attempts as $attempt){
        $attemptcount++;
      }
      $return['AttemptId'] = $attempt['AttemptId'];
      $return['AttemptCount'] = $attemptcount;
      $return['AttemptInfo'] = $attempt['AttemptInfo'];
      $return['Completed'] = $attempt['Completed'];
      $return['PassFail'] = $attempt['PassFail'];
      return $return;
  }

  Public function loginDelegate($userid){
      $url = "https://wsapi.360membership.com.au/mms2018/api/oa/GetDelegateByDelegateWebId";
      $data = array(
                    "PassKey" => "cwpR7blHpiMC8Txu2EwTcLfrpAYTeffnAzgaih5zybfqoYf967N1NA",
                    "DelegateWebId" => $userid
                  );
      $payload = json_encode($data);
      $curl = curl_init($url);
      curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
      curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
      curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($curl, CURLINFO_HEADER_OUT, true);
      curl_setopt($curl, CURLOPT_POST, true);
      curl_setopt($curl, CURLOPT_POSTFIELDS, $payload);

      curl_setopt($curl, CURLOPT_HTTPHEADER, array(
          'Content-Type: application/json',
          'Content-Length: ' . strlen($payload))
      );

      $jsonfile = curl_exec($curl);
      if (curl_errno($curl)) {
         print curl_error($curl);
      }
      curl_close($curl);

      return json_decode($jsonfile, FALSE);
  }

  Public function loginMember($cookie){
        $data = $cookie;
        parse_str($data, $output);
        $url = "https://wsapi.360membership.com.au/mms2018/api/oa/checkToken";
        $dataarray = array(
            "PassKey" => "cwpR7blHpiMC8Txu2EwTcLfrpAYTeffnAzgaih5zybfqoYf967N1NA",
            "MemberId" => $output['MemberId'],
            "SessionToken" => $output['SessionToken']
            );
        $content = json_encode($dataarray);
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLOPT_VERBOSE, true);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
        $fp = fopen(dirname(__FILE__).'/errorlog.txt', 'w');
        curl_setopt($curl, CURLOPT_STDERR, $fp);
        curl_setopt($curl, CURLOPT_HTTPHEADER,
                array("Content-type: application/json; charset=UTF-8"));
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $content);

        $json_response = curl_exec($curl);

        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);

        curl_close($curl);
        $member = json_decode($json_response, FALSE);

          $url = "https://wsapi.360membership.com.au/mms2018/api/oa/GetDelegateByMemberId";
          $data = array(
                        "PassKey" => "cwpR7blHpiMC8Txu2EwTcLfrpAYTeffnAzgaih5zybfqoYf967N1NA",
                        "MemberId" => $output['MemberId']
                      );
          $payload = json_encode($data);
          $curl = curl_init($url);
          curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
          curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
          curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
          curl_setopt($curl, CURLINFO_HEADER_OUT, true);
          curl_setopt($curl, CURLOPT_POST, true);
          curl_setopt($curl, CURLOPT_POSTFIELDS, $payload);

          curl_setopt($curl, CURLOPT_HTTPHEADER, array(
              'Content-Type: application/json',
              'Content-Length: ' . strlen($payload))
          );

          $jsonfile = curl_exec($curl);
          if (curl_errno($curl)) {
             print curl_error($curl);
          }
          curl_close($curl);

          $record = json_decode($jsonfile, FALSE);
          $return = array();
          foreach($record as $rec){
            if(empty($rec->CustomField1)){
              $return[$rec->ConferenceID]['DelegateWebID'] = $rec->DelegateWebID;
              $return['MemberId'] = $rec->MemberId;
            }
          }
          return json_encode($return);

  }

  Public function retrieveAssignedSessions($userid, $conferenceid, $ismember = FALSE){
        $url = "https://wsapi.360membership.com.au/mms2018/api/oa/GetDelegates";
        if($ismember){
          $data = array(
                        "PassKey" => "cwpR7blHpiMC8Txu2EwTcLfrpAYTeffnAzgaih5zybfqoYf967N1NA",
                        "ConferenceId" => $conferenceid,
                        "MemberId" => $userid
                      );
        } else {
          $data = array(
                        "PassKey" => "cwpR7blHpiMC8Txu2EwTcLfrpAYTeffnAzgaih5zybfqoYf967N1NA",
                        "ConferenceId" => $conferenceid,
                        "DelegateWebId" => $userid
                      );
        }
        $payload = json_encode($data);
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $payload);

        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($payload))
        );

        $jsonfile = curl_exec($curl);
        if (curl_errno($curl)) {
           print curl_error($curl);
        }
        curl_close($curl);

        return json_decode($jsonfile, FALSE);
  }
}

Class Delete {
  Public function delete_Answer($answerid){
    $core = Core::getInstance();
    $deletesql = $core->dbc->prepare('DELETE FROM cpd_answers WHERE AnswerId=:AnswerId');
    $deletesql->execute(array(
      "AnswerId" => $answerid
    ));
    return $answerid . ' Deleted';
  }
  Public function delete_Question($questionid){
    $core = Core::getInstance();
    $deletesql = $core->dbc->prepare('DELETE FROM cpd_questions WHERE QuestionId=:QuestionId');
    $deletesql->execute(array(
      "QuestionId" => $questionid
    ));
    $answerssql = $core->dbc->prepare('DELETE FROM cpd_answers WHERE ParentId=:ParentId');
    $answerssql->execute(array(
      "ParentId" => $questionid
    ));
    return $questionid . ' Deleted';
  }
  Public function delete_allQuestions($sessionid){
    $core = Core::getInstance();
    $questionssql = $core->dbc->prepare('SELECT QuestionId FROM cpd_questions WHERE ParentId=:ParentId');
    $questionssql->execute(array(
      "ParentId" => $sessionid
    ));
    $questions = $questionssql->fetchAll(PDO::FETCH_ASSOC);
    foreach($questions as $question){
      $answerssql = $core->dbc->prepare('DELETE FROM cpd_answers WHERE ParentId=:ParentId');
      $answerssql->execute(array(
        "ParentId" => $question['QuestionId']
      ));
    }
    $deletesql = $core->dbc->prepare('DELETE FROM cpd_questions WHERE ParentId=:ParentId');
    $deletesql->execute(array(
      "ParentId" => $sessionid
    ));
    return 'All Questions Deleted';
  }
}
function EventOverride($boolean = 0, $eventid = ''){
    $core = Core::getInstance();
    if($boolean == '0'):
       $overridesql = $core->dbc->prepare("UPDATE cpd_events SET override='1' WHERE EventId=:eventid");
       $overridesql->execute(array("eventid" => $eventid));
       $return = array("return" => 1);
       print(json_encode($return));
    else:
       $overridesql = $core->dbc->prepare("UPDATE cpd_events SET override='0' WHERE EventId=:eventid");
       $overridesql->execute(array("eventid" => $eventid));
       $return = array("return" => 0);
       print(json_encode($return));
    endif;
}

function SessionHide($boolean = 0, $sessionid = ''){
    $core = Core::getInstance();
    if($boolean == '0'):
       $hidesql = $core->dbc->prepare("UPDATE cpd_sessions SET hidden='1' WHERE SessionId=:sessionid");
       $hidesql->execute(array("sessionid" => $sessionid));
       $return = array("return" => 1);
       print(json_encode($return));
    else:
       $hidesql = $core->dbc->prepare("UPDATE cpd_sessions SET hidden='0' WHERE SessionId=:sessionid");
       $hidesql->execute(array("sessionid" => $sessionid));
       $return = array("return" => 0);
       print(json_encode($return));
    endif;
}
function AttendanceOnly($boolean = 0, $sessionid = ''){
    $core = Core::getInstance();
    if($boolean == '0'):
       $aosql = $core->dbc->prepare("UPDATE cpd_sessions SET attendance_only='1' WHERE SessionId=:sessionid");
       $aosql->execute(array("sessionid" => $sessionid));
       $return = array("return" => 1);
       print(json_encode($return));
    else:
       $aosql = $core->dbc->prepare("UPDATE cpd_sessions SET attendance_only='0' WHERE SessionId=:sessionid");
       $aosql->execute(array("sessionid" => $sessionid));
       $return = array("return" => 0);
       print(json_encode($return));
    endif;
}

function isAttendanceOnly($sessionid){
    $core = Core::getInstance();
    $aosql = $core->dbc->prepare("SELECT attendance_only FROM cpd_sessions WHERE SessionId=:sessionid");
    $aosql->execute(array("sessionid" => $sessionid));
    $aores = $aosql->fetch(PDO::FETCH_ASSOC);
    $return = (int) $aores['attendance_only'];
    return $return;
}
if($_REQUEST){
  $r = $_REQUEST;
  $action = $_REQUEST['action'];
  if($action == 'live-poll'){
    $core = Core::getInstance();
    $pollsql = $core->dbc->prepare('SELECT * FROM cpd_poll_status WHERE ParentId=:ParentId');
    $pollsql->execute(array(
      "ParentId" => $r['sessionId']
    ));
    $pollresult = $pollsql->fetch(PDO::FETCH_ASSOC);
    print(json_encode($pollresult));
  }
  if($action == 'event-override'){
      EventOverride($r['override'], $r['eventid']);
  }
  if($action == 'session-hide'){
      SessionHide($r['hide'], $r['sessionid']);
  }
  if($action == 'attendance-only'){
      AttendanceOnly($r['attendance-only'], $r['sessionid']);
  }
  if($action == 'session-edit'){
    $newq = new session_Record();
    $returnarray = array();
    $sid = $newq->record_SessionDetails($request->session->sessionId, $request->session);
    $q = 1;
    foreach($request->question as $question){
      $qid = $newq->record_question($request->session->sessionId, $question);
      $returnarray['questions'][$q]['id'] = $qid['questionid'];
      $returnarray['questions'][$q]['number'] = $qid['questionnumber'];
      $a = 1;
      foreach($question->answer as $answer){
        $answer_ret = $newq->record_Answer($qid['questionid'], $answer);
        $returnarray['questions'][$q]['answer'][$a] = $answer_ret;
        $a++;
      }
      $q++;
    }
    print(json_encode($returnarray));
  }
  if($action == 'delete-answer'){
    $delete = new Delete();
    print(json_encode($delete->delete_Answer($r['answerId'])));
  }
  if($action == 'delete-question'){
    $delete = new Delete();
    print(json_encode($delete->delete_Question($r['questionId'])));
  }
  if($action == 'delete-allquestions'){
    $delete = new Delete();
    print(json_encode($delete->delete_allQuestions($r['sessionId'])));
  }
}
?>
