<?php
 require_once('inc/cpd-head.php');
?>
<!DOCTYPE html>
<html>
  <head>
    <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1.0">
    <title>elitecpd</title>
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/materialize/1.0.0/css/materialize.min.css">
    <link rel="stylesheet" href="/style.css" type="text/css">
    <script src="https://cdn.tiny.cloud/1/myp8n7xbo2opl1715hrpd8s76aa65oq92ty0lxkujhvrpbx9/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
  </head>
  <body>
    <?php
      $sid = $_GET['s_id'];
      $ret_sess = new retrieve_CPD();
      $session = $ret_sess->retrieve_session($sid);
    ?>
    <form method="post" id="session-form">
      <input type="hidden" name="action" value="session-edit">
      <input type="hidden" id="sessionid" name="session[sessionId]" value="<?php echo $session->SessionId; ?>">
<div class="container body-container">
  <div class="bg-header"><h2 class=" blue-grey-text text-darken-2 truncate"><?php echo $session->SessionName; ?></h2></div>
  <div class="dashboard-container row" style="margin: 0;">
    <div class="row col s12">
      <div class="breadcrumbs">
        <ul>
          <li><a href="https://qldntcpd.optometry.org.au">Dashboard</a></li>
          <li><?php echo $session->SessionName; ?></li>
        </ul>
      </div>
    </div>
    <div class="row" style="padding-top: 2em;">
    <div class="input-field col s2"><input id="sessiondate" type="text" class="datepicker" name="session[date]"><label>Session Date</label></div>
    <div class="input-field col s2"><input id="sessionstarttime" type="text" class="timepicker" name="session[startTime]"><label>Start Time</label></div>
    <div class="input-field col s2"><input id="sessionendtime" type="text" class="timepicker" name="session[endTime]"><label>End Time</label></div>
    <div class="input-field col s2">
      <select class="icons" id="sessionslot" name="session[slot]">
        <option value="" disabled selected>Choose Slot</option>
        <option value="1" data-icon="/img/red.jpg">Slot 1</option>
        <option value="2" data-icon="/img/green.jpg">Slot 2</option>
        <option value="3" data-icon="/img/blue.jpg">Slot 3</option>
        <option value="4" data-icon="/img/yellow.jpg">Slot 4</option>
        <option value="5" data-icon="/img/orange.jpg">Slot 5</option>
        <option value="6" data-icon="/img/purple.jpg">Slot 6</option>
      </select>
      <label>Session Slot</label>
    </div>
    <div class="input-field col s2">
      <a class="add-question waves-effect waves-light btn-flat" data-question="1">Add Question +</a>
    </div>
    <div class="input-field col s1"><a class="save-session"><i class="material-icons">save</i></a></div>
    <div class="input-field col s1"><a class="delete-all red-text text-darken-4"><i class="material-icons">delete_sweep</i></a></div>
  </div>
  <div class="row" style="margin: 0 auto;">
    <ul id="questions" class="collapsible row col s12">
      <li class="question row col s12" id="question-1" data-question="1">
        <input name="question[1][order]" type="hidden" value="1" />
        <div class="collapsible-header blue-grey-text text-darken-2"><i class="material-icons">contact_support</i><span>Question</span></div>
        <div class="collapsible-body row">
        <div class="question-text col s11">
          <label for="question-1-text">Question</label>
          <textarea id="question-1-text" class="tinymce-textarea" name="question[1][questionText]"></textarea>
        </div>
        <div class="add-answer col s1"><a class="add-answer waves-effect waves-light btn-small" data-question="1">Add</a></div>
          <div id="answers">
            <div class="answer row col s12" id="question-1-answer-1" data-question="1" data-answer="1">
              <div class="answer-text col s9">
                <div class="input-field">
                    <label for="question-1-answer-1-text" class="active">Answer</label>
                    <textarea id="question-1-answer-1-text" class="tinymce-textarea" name="question[1][answer][1][answerText]"></textarea>
                </div>
              </div>
              <div class="answer-iscorrect col s2">
                <p>
                  <label>
                    <input name="question[1][iscorrect]" type="radio" value="1" checked />
                    <span>Correct?</span>
                  </label>
                </p>
              </div>
              <div class="delete-answer col s1"></div>
              <input name="question[1][answer][1][order]" type="hidden" value="1" />
            </div>
        </div>
      </div>
      </li>
    </ul>
  </div>
  <footer class="page-footer blue-grey lighten-5">
      <div class="container">
        <div class="row">
          <div class="col l6 s12">
            <h6 class="blue-grey-text text-darken-4">elitecpd</h6>
            <p class="blue-grey-text text-darken-4"></p>
          </div>
          <div class="col l4 offset-l2 s12">
            <ul>
              <li><a class="blue-grey-text text-darken-3" href="https://qldntcpd.optometry.org.au">Home</a></li>
              <li><a class="blue-grey-text text-darken-3" href="https://qldntcpd.optometry.org.au/inc/session-logout/">Log Out</a></li>
              <li><a class="blue-grey-text text-darken-3" href="https://www.optometry.org.au/about-us/our-organisation/optometry-vic-sa/">Optometry QLD/NT</a></li>
              <li><a class="blue-grey-text text-darken-3" href="https://www.optometry.org.au/cpd-publications-events/cpd-event-calendar/">CPD Calendar</a></li>
            </ul>
          </div>
        </div>
      </div>
      <div class="footer-copyright blue darken-1">
        <div class="container">
        &copy;2019 Fusoniq Solutions Pty Ltd
        </div>
      </div>
    </footer>
  </div>
  <script>
    <?php
      $prefill = $ret_sess->construct_prefillArray($sid);
      echo 'var prefill = '.json_encode($prefill).';';
    ?>
  </script>
</div>
</form>
  <script src="//ajax.googleapis.com/ajax/libs/jquery/1.7.2/jquery.min.js" type="text/javascript"></script>
  <script src="//cdnjs.cloudflare.com/ajax/libs/modernizr/2.5.3/modernizr.min.js" type="text/javascript"></script>
  <script src="/js/scripts.js?v=270324.65" type="text/javascript"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/materialize/1.0.0/js/materialize.min.js"></script>
  <script type="text/javascript">
  $('.datepicker').datepicker();
  $('.timepicker').timepicker();
  $('select').formSelect();
  $('.collapsible').collapsible();
  </script>
  <script type="text/javascript">
      
    $(document).ready(function(){
      $('.datepicker').datepicker({format: 'dd/mm/yyyy'});
      $('.timepicker').timepicker();
      $('select').formSelect();
      $('.collapsible').collapsible();
      $('.radio:checked').change();
    });

    $(window).load(function(){
        prefill_sessionQuestions(prefill);
        
        tinymce.init(tinymceoptions);
    });
  </script>
  </body>
</html>
